<?php

namespace FirstpointCh\Shop\Cart;

use FirstpointCh\Shop\Models\Cart;

class CartManager
{
    public Cart $cart;

    public function __construct()
    {
        $this->reset();
    }

    public function reset()
    {
        $this->cart = $this->initCart();

        if (! empty($this->cart->id)) {
            $this->cart;
        }
    }

    public function initCart(): Cart
    {
        $anonymousCart = $this->getAnonymousCart();
        $customerCart = $this->getCustomerCart();

        if (empty($anonymousCart) && empty($customerCart)) {
            return $this->newCartInstance();
        }

        if (! empty($anonymousCart) && empty($customerCart)) {
            return auth()->check()
                ? $this->convertAnonymousCartToCustomerCart($anonymousCart)
                : $anonymousCart;
        }

        if (empty($anonymousCart) && ! empty($customerCart)) {
            return $customerCart;
        }

        if (! empty($anonymousCart) && ! empty($customerCart)) {
            return $this->mergeAnonymousCartIntoCustomerCart($anonymousCart, $customerCart);
        }
    }

    public function getCustomerCart()
    {
        return auth()->user()?->cart;
    }

    public function getAnonymousCart(): ?Cart
    {
        if (! session()->has('shop::cart') || empty(session('shop::cart'))) {
            return null;
        }

        $cart = Cart::whereNull('customer_id')->find(session('shop::cart'));

        if (is_null($cart)) {
            session()->forget('shop::cart');
        }

        return $cart;
    }

    public function newCartInstance()
    {
        return new Cart([
            'customer_id' => auth()->id(),
            'region_id' => 1,
        ]);
    }

    public function mergeAnonymousCartIntoCustomerCart($anonymousCart, $customerCart): Cart
    {
        foreach ($anonymousCart->items as $item) {
            $customerCart->add(
                id: $item->orderable->id,
                quantity: $item->quantity,
            );

            $item->delete();
        }

        $anonymousCart->delete();

        session()->forget('shop::cart');

        return $customerCart;
    }

    public function convertAnonymousCartToCustomerCart($anonymousCart): Cart
    {
        $anonymousCart->update([
            'customer_id' => auth()->id(),
        ]);

        session()->forget('shop::cart');

        return $anonymousCart;
    }
}
