# Stripe Gateway

## Configuration

Go to your ```shop.php``` config file and find the ```payment_gateways``` section and add the Stripe Checkout gateway:

```php
'payment_gateways' => [
    \FirstpointCh\Shop\Payment\Gateway\StripeCheckoutGateway::class => [
        'slug' => 'stripe-checkout',
        'public_key' => env('STRIPE_PUBLIC_KEY'),
        'secret_key' => env('STRIPE_SECRET_KEY'),
        'webhook_secret' => env('STRIPE_WEBHOOK_SECRET'),
    ],
],
```

Create an API key in the [Stripe Dashboard](https://dashboard.stripe.com/apikeys) and create a Webhook to the following URL ```[my-shop.com]/shop/payment/stripe-checkout/handle``` and copy the webhook secret.

In your ```.env``` file, add the following variables

```env
STRIPE_PUBLIC_KEY=[PUBLIC_KEY]
STRIPE_SECRET_KEY=[SECRET_KEY]
STRIPE_WEBHOOK_SECRET=[WEBHOOK_SECRET]
```

## Testing webhook

When testing, you can use the [https://stripe.com/docs/stripe-cli](stripe-cli) to handle webhooks. Install the stripe-cli and create a listener:

```shell
stripe login # This should be run once

stripe listen --forward-to my-shop.test/shop/payment/stripe-checkout/handle
```

Get your webhook secret and put it in the ```.env``` file.  