<?php

namespace FirstpointCh\Shop\Database\Factories;

use FirstpointCh\Shop\Models\Order;
use FirstpointCh\Shop\Models\OrderActivity;
use Illuminate\Database\Eloquent\Factories\Factory;

class OrderActivityFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = OrderActivity::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'order_id' => function () {
                return Order::factory()->create();
            },
            'user_name' => $this->faker->name(),
            'action_type' => 'comment',
            'action_title' => $this->faker->word(),
            'message' => $this->faker->sentence(),
        ];
    }
}
