<?php

use FirstpointCh\Shop\Models\Customer;
use FirstpointCh\Shop\Models\Order;
use FirstpointCh\Shop\Models\OrderActivity;
use FirstpointCh\Shop\Models\OrderItem;
use FirstpointCh\Shop\Models\OrderTax;
use FirstpointCh\Shop\Models\Payment;
use Illuminate\Support\Collection;

it('belongs to a customer', function () {
    $customer = Customer::factory()->create();
    $order = Order::factory()->createQuietly([
        'customer_id' => $customer->id,
    ]);

    $this->assertInstanceOf(Customer::class, $order->customer);
    $this->assertEquals($customer->id, $order->customer->id);
});

it('has many payments', function () {
    $order = Order::factory()->createQuietly();

    Payment::factory()->create([
        'order_id' => $order->id,
    ]);

    $this->assertCount(1, $order->payments);
    $this->assertInstanceOf(Collection::class, $order->payments);
    $this->assertInstanceOf(Payment::class, $order->payments->first());
});

it('has many items', function () {
    $order = Order::factory()->createQuietly();

    OrderItem::factory()->create([
        'order_id' => $order->id,
    ]);

    $this->assertCount(1, $order->items);
    $this->assertInstanceOf(Collection::class, $order->items);
    $this->assertInstanceOf(OrderItem::class, $order->items->first());
});

it('has many activities', function () {
    $order = Order::factory()->createQuietly();

    OrderActivity::factory()->create([
        'order_id' => $order->id,
    ]);

    $this->assertCount(1, $order->activities);
    $this->assertInstanceOf(Collection::class, $order->activities);
    $this->assertInstanceOf(OrderActivity::class, $order->activities->first());
});

it('has many taxes', function () {
    $order = Order::factory()->createQuietly();

    OrderTax::factory()->create([
        'order_id' => $order->id,
    ]);

    $this->assertCount(1, $order->taxes);
    $this->assertInstanceOf(Collection::class, $order->taxes);
    $this->assertInstanceOf(OrderTax::class, $order->taxes->first());
});
