<?php

use FirstpointCh\Shop\Models\Attribute;
use FirstpointCh\Shop\Models\AttributeOption;
use FirstpointCh\Shop\Models\ProductType;
use FirstpointCh\Shop\Models\Variant;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

it('belongs to many variants', function () {
    $attribute = Attribute::factory()->create();
    $variant = Variant::factory()->create();

    $attribute->variants()->attach($variant);

    $this->assertCount(1, $attribute->variants);
    $this->assertInstanceOf(Collection::class, $attribute->variants);
    $this->assertInstanceOf(Variant::class, $attribute->variants->first());
});

it('belongs to many product type', function () {
    $attribute = Attribute::factory()->create();
    $productType = ProductType::factory()->create();

    $attribute->productTypes()->attach($productType, ['type' => 'variant']);

    $this->assertCount(1, $attribute->productTypes);
    $this->assertInstanceOf(Collection::class, $attribute->productTypes);
    $this->assertInstanceOf(ProductType::class, $attribute->productTypes->first());
});

it('has many options', function () {
    $attribute = Attribute::factory()->create();
    $variant = Variant::factory()->create();

    DB::table('attribute_variant')->insert([
        'attribute_id' => $attribute->id,
        'variant_id' => $variant->id,
        'value_option_id' => $attribute->options()->create(['value' => 'XL'])->id,
    ]);

    $this->assertCount(1, $attribute->options);
    $this->assertInstanceOf(Collection::class, $attribute->options);
    $this->assertInstanceOf(AttributeOption::class, $attribute->options->first());
    $this->assertEquals('XL', $attribute->options->first()->value);
});
