<?php

namespace FirstpointCh\Shop\Payment\Gateway;

use FirstpointCh\Shop\Exceptions\PaymentDoesNotExist;
use FirstpointCh\Shop\Models\Payment;
use FirstpointCh\Shop\Payment\Enums\GatewayStatus;
use Illuminate\Http\Request;

class TestGateway extends PaymentGateway
{
    public function init(Payment $payment)
    {
        return redirect()
            ->route('shop::payment.handle', [
                'gateway' => 'testing',
                'reference' => $payment->reference,
            ]);
    }

    public static function getPaymentIntent(Request $request): Payment
    {
        $payment = customer()->payments()->where('reference', request('reference'))->first();

        if (empty($payment)) {
            throw new PaymentDoesNotExist();
        }

        return $payment;
    }

    public function handle(): GatewayStatus
    {
        return GatewayStatus::Charged;
    }
}
