<?php

namespace FirstpointCh\Shop\Payment\Gateway;

use FirstpointCh\Shop\Models\Payment;
use Illuminate\Http\Request;

class PostfinanceGateway extends PaymentGateway
{
    public function init(Payment $payment)
    {
        return view('shop::payment.postfinance.form', [
            'ORDERID' => $this->payment->reference,
            'AMOUNT' => $this->payment->amount,
        ]);
    }

    public static function fromRequest(Request $request)
    {
        $reference = $request->get('ORDERID');

        $payment = Payment::where('reference', $reference)->first();

        return new self($payment);
    }

    public function validate(Request $request)
    {
        // Temp: check SHA
        // if (true) {
        $this->setError('Invalid SHA');

        return false;
        // }
    }
}
