<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Order\Enums\OrderStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'amount' => 'decimal:2',
    ];

    protected $appends = ['amount_formatted'];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function redirect()
    {
        return app('payment.'.$this->gateway)->redirect();
    }

    public function getAmountFormattedAttribute()
    {
        return money()->format($this->amount);
    }

    public function success(OrderStatus $status)
    {
        $this->order->items->each(function ($item) {
            $item->variant->decrement('stock', $item->quantity);
        });

        $this->update([
            'status' => 'success',
            'status_message' => null,
        ]);

        $this->order->update([
            'status' => $status,
        ]);

        checkout()->reset();
        cart()->reset();
    }

    public function failed($message)
    {
        $this->update([
            'status' => 'failed',
            'status_message' => $message,
        ]);
    }

    public function error($message)
    {
        $this->update([
            'status' => 'error',
            'status_message' => $message,
        ]);
    }
}
