<?php

namespace FirstpointCh\Shop\Listeners;

use FirstpointCh\Shop\Models\Customer;
use Illuminate\Notifications\Events\NotificationSent;
use Illuminate\Support\Arr;

class LogSentNotification
{
    /**
     * Handle the event.
     *
     * @return void
     */
    public function handle(NotificationSent $event)
    {
        if ($event->notifiable instanceof Customer) {
            $data = (array) $event->notification;
            $locale = Arr::pull($data, 'locale');

            unset($data['id']);

            $event->notifiable->notificationLogs()->create([
                'type' => get_class($event->notification),
                'data' => $data,
                'locale' => $locale ?? app()->getLocale() ?? config('app.fallback_locale') ?? null,
                'via' => $event->notification->via($event->notifiable),
            ]);
        }
    }
}
