<?php

namespace FirstpointCh\Shop\Data\Cp;

use Spatie\LaravelData\Data;

class ProductFormData extends Data
{
    public function __construct(
        public array $name,
        public int $product_type_id,
        public ?string $status = 'draft',
        public ?array $short_description = null,
        public ?array $description = null,
        public ?array $base_attributes = [],
        public ?array $extra_attributes = [],
        public ?array $categories = [],
        public ?int $brand_id = null,
    ) {
    }

    public static function rules(): array
    {
        return [
            'status' => 'nullable',
            'name' => 'required',
            'short_description' => 'nullable',
            'description' => 'nullable',
            'product_type_id' => 'required|exists:product_types,id',
            'brand_id' => 'nullable|exists:brands,id',
            'base_attributes' => 'array',
            'base_attributes.*.attribute_id' => 'required|exists:attributes,id',
            'base_attributes.*.value_option_id' => 'nullable|exists:attribute_options,id',
            'base_attributes.*.value_translated' => 'nullable',
            'base_attributes.*.value_string' => 'nullable',
            'base_attributes.*.value_integer' => 'nullable',
            'extra_attributes' => 'array',
            'extra_attributes.*.attribute_id' => 'required|exists:attributes,id',
            'extra_attributes.*.value_option_id' => 'nullable|exists:attribute_options,id',
            'extra_attributes.*.value_translated' => 'nullable',
            'extra_attributes.*.value_string' => 'nullable',
            'extra_attributes.*.value_integer' => 'nullable',
        ];
    }

    public function getProductData()
    {
        return [
            'status' => $this->status,
            'name' => $this->name,
            'short_description' => $this->short_description,
            'description' => $this->description,
            'product_type_id' => $this->product_type_id,
            'brand_id' => $this->brand_id,
        ];
    }

    public function getAttributes()
    {
        $baseAttributes = collect($this->base_attributes)
            ->mapWithKeys(fn ($attr) => [
                $attr['attribute_id'] => [
                    'value_option_id' => $attr['value_option_id'] ?? null,
                    'value_translated' => $attr['value_translated'] ?? null,
                    'value_string' => $attr['value_string'] ?? null,
                    'value_integer' => $attr['value_integer'] ?? null,
                ],
            ])->toArray();

        $extraAttributes = collect($this->extra_attributes)
            ->mapWithKeys(fn ($attr) => [
                $attr['attribute_id'] => [
                    'value_option_id' => $attr['value_option_id'] ?? null,
                    'value_translated' => $attr['value_translated'] ?? null,
                    'value_string' => $attr['value_string'] ?? null,
                    'value_integer' => $attr['value_integer'] ?? null,
                ],
            ])->toArray();

        return $baseAttributes + $extraAttributes; // Merge but keep keys
    }
}
