# Extend the CP

TODO: Make publishable stubs

## Introduction

You can extend the cp with custom pages. Pages are VueJS components that relie on InertiaJs.

## Getting started

Create a ```cp.js``` file in ```resources/js``` folder with the following content:

```js
import CustomPage from './Cp/CustomPage.vue';

Shop.registerPage('CustomPage', CustomPage)
```

Create the ```resources/js/Cp/CustomPage.vue``` component:

```vue
<template>
    <div>It Works !</div>
</template>
```

Add the script to ```vite.config.js```

```js
export default defineConfig({
    plugins: [
        laravel([
            ...
            'resources/js/cp.js',
        ]),
...
```

Inject the script in the cp from a service provider's boot method

```php
public function boot()
{
    app('shop::shop')->registerScripts([
        'resources/js/cp.js',
    ]);
}
```

Compile assets

```bash
npm run build
```

Create a ```routes/cp.php```. This file is detected and automatically loaded by the shop package. From there, you can create a route and return your inertia component.

```php
Route::get('/custom-page', function () {
    return inertia('TestComponent');
});
```

This page is availabe at ```https://yourstore.test/cp/custom-page```
