<?php

namespace FirstpointCh\Shop\Database\Factories;

use FirstpointCh\Shop\Models\Cart;
use FirstpointCh\Shop\Models\CartTax;
use FirstpointCh\Shop\Models\TaxRule;
use Illuminate\Database\Eloquent\Factories\Factory;

class CartTaxFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = CartTax::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'cart_id' => function () {
                return Cart::factory()->create()->id;
            },
            'tax_rule_id' => function () {
                return TaxRule::factory()->create()->id;
            },
            'taxable_amount' => $this->faker->randomFloat(2, 1, 100),
        ];
    }
}
