<?php

namespace FirstpointCh\Shop\Database\Factories;

use FirstpointCh\Shop\Models\Cart;
use FirstpointCh\Shop\Models\CartItem;
use FirstpointCh\Shop\Models\Variant;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class CartItemFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = CartItem::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'id' => Str::uuid(),
            'cart_id' => function () {
                return Cart::factory()->create();
            },
            'name' => $this->faker->word(),
            'orderable_type' => 'FirstpointCh\Shop\Models\Variant',
            'orderable_id' => function () {
                return Variant::factory()->create();
            },
            'quantity' => $this->faker->numberBetween(1, 10),
        ];
    }
}
