<?php

return [

    'locales' => [
        'fr' => [
            'name' => 'Français',
            'base_path' => '/',
        ],
        'en' => [
            'name' => 'English',
            'base_path' => '/en',
        ],
    ],

    'regions' => [
        'ch' => [
            'name' => 'Suisse',
            'slug' => 'ch',
            'currency' => 'CHF',
            'currency_format' => 'de_CH',
            'countries' => [
                'CH',
            ],
        ],
        'fr' => [
            'name' => 'France',
            'slug' => 'fr',
            'currency' => 'EUR',
            'currency_format' => 'fr_FR',
            'countries' => [
                'FR',
            ],
        ],
    ],

    'default_region' => 'ch',

    'middleware' => [
        'web' => [
            'web',
        ],
    ],

    'cp' => [
        'base_url' => '/cp',
        'guard' => 'cp',
    ],

    'api' => [
        'base_url' => '/shop/api',
    ],

    'payment_gateways' => [
        \FirstpointCh\Shop\Payment\Gateway\TestGateway::class => [
            'slug' => 'test-gateway',
        ],
    ],

    'carriers' => [
        'default' => \FirstpointCh\Shop\Carrier\DefaultCarrier::class,
    ],

    'media' => [
        'cms_assets' => [
            'disk' => 'public',
        ],

        'product' => [
            'disk' => 'public',

            'conversions' => [
                'thumbnail' => [
                    'width' => 200,
                    'height' => 200,
                ],
            ],
        ],
    ],

];
