<?php

use FirstpointCh\Shop\Models\ShippingMethod;
use FirstpointCh\Shop\Models\ShippingMethodPrice;
use Illuminate\Support\Collection;

it('belongs to many regions', function () {
    $shippingMethod = ShippingMethod::factory()->create();

    $shippingMethod->prices()->create([
        'region' => config('shop.default_region'),
        'price' => 123,
    ]);

    $this->assertCount(1, $shippingMethod->prices);
    $this->assertInstanceOf(Collection::class, $shippingMethod->prices);
    $this->assertInstanceOf(ShippingMethodPrice::class, $shippingMethod->prices->first());
    $this->assertEquals(123, $shippingMethod->prices()->first()->price);
});
