<?php

use FirstpointCh\Shop\Events\OrderCancelled;
use FirstpointCh\Shop\Events\OrderCreated;
use FirstpointCh\Shop\Events\OrderPaid;
use FirstpointCh\Shop\Events\OrderShipped;
use FirstpointCh\Shop\Models\Order;
use FirstpointCh\Shop\Order\Enums\OrderStatus;
use Illuminate\Support\Facades\Event;

it('dispatches an event when an order is created', function () {
    Event::fake([OrderCreated::class]);

    $order = Order::factory()->create();

    Event::assertDispatched(function (OrderCreated $event) use ($order) {
        return $event->order->is($order);
    });
});

it('dispatches an event when an order is created as paid', function () {
    Event::fake([OrderCreated::class, OrderPaid::class]);

    $order = Order::factory()->create([
        'status' => OrderStatus::Paid,
    ]);

    Event::assertDispatched(function (OrderCreated $event) use ($order) {
        return $event->order->is($order);
    });

    Event::assertDispatched(function (OrderPaid $event) use ($order) {
        return $event->order->is($order);
    });
});

it('dispatches an event when an order is paid', function () {
    Event::fake([OrderPaid::class]);

    $order = Order::factory()->createQuietly();

    $order->update([
        'status' => OrderStatus::Paid,
    ]);

    Event::assertDispatched(function (OrderPaid $event) use ($order) {
        return $event->order->is($order);
    });
});

it('dispatches an event when an order is created as shipped', function () {
    Event::fake([OrderCreated::class, OrderShipped::class]);

    $order = Order::factory()->create([
        'status' => OrderStatus::Shipped,
    ]);

    Event::assertDispatched(function (OrderCreated $event) use ($order) {
        return $event->order->is($order);
    });

    Event::assertDispatched(function (OrderShipped $event) use ($order) {
        return $event->order->is($order);
    });
});

it('dispatches an event when an order is shipped', function () {
    Event::fake([OrderShipped::class]);

    $order = Order::factory()->createQuietly();

    $order->update([
        'status' => OrderStatus::Shipped,
    ]);

    Event::assertDispatched(function (OrderShipped $event) use ($order) {
        return $event->order->is($order);
    });
});

it('dispatches an event when an order is created as cancelled', function () {
    Event::fake([OrderCreated::class, OrderCancelled::class]);

    $order = Order::factory()->create([
        'status' => OrderStatus::Cancelled,
    ]);

    Event::assertDispatched(function (OrderCreated $event) use ($order) {
        return $event->order->is($order);
    });

    Event::assertDispatched(function (OrderCancelled $event) use ($order) {
        return $event->order->is($order);
    });
});

it('dispatches an event when an order is cancelled', function () {
    Event::fake([OrderCancelled::class]);

    $order = Order::factory()->createQuietly();

    $order->update([
        'status' => OrderStatus::Cancelled,
    ]);

    Event::assertDispatched(function (OrderCancelled $event) use ($order) {
        return $event->order->is($order);
    });
});
