<?php

use FirstpointCh\Shop\Models\Attribute;
use FirstpointCh\Shop\Models\Variant;
use Illuminate\Support\Collection;

it('belongs to many attributes', function () {
    $variant = Variant::factory()->create();
    $attribute = Attribute::factory()->create([
        'type' => 'text',
    ]);

    $variant->attributes()->attach($attribute->id, ['value' => 'foo', 'type' => 'text']);

    $this->assertInstanceOf(Collection::class, $variant->attributes);
    $this->assertInstanceOf(Attribute::class, $variant->attributes->first());
    $this->assertEquals('foo', $variant->attributes->first()->pivot->value);
});
