<?php

use FirstpointCh\Shop\Models\Attribute;
use FirstpointCh\Shop\Models\Variant;

it('filters active variants', function () {
    $inactive = Variant::factory()->create(['is_active' => false]);
    $active = Variant::factory()->create(['is_active' => true]);

    expect(Variant::get())->toHaveCount(2);
    expect(Variant::active()->get())->toHaveCount(1);
    expect(Variant::active()->first())->toMatchArray(['id' => $active->id]);
});

it('loads the variant price', function () {
    $variant = Variant::factory()->create();

    $variant->prices()->create(['region' => 'ch', 'price' => 10, 'product_id' => $variant->product_id]);
    $variant->prices()->create(['region' => 'fr', 'price' => 20, 'product_id' => $variant->product_id]);

    // It takes the current region if region aware
    shop()->regionAware();
    shop()->setRegion('ch');
    expect(Variant::withPrice()->find($variant->id)->price)->toBe(10);

    shop()->setRegion('fr');
    expect(Variant::withPrice()->find($variant->id)->price)->toBe(20);
});

it('filters variants by attribute', function () {
    $attribute = Attribute::factory()->create(['key' => 'color']);

    $variant = Variant::factory()->create();
    $variant->attributes()->attach($attribute, ['type' => 'text', 'value' => ['en' => 'red']]);

    $variant2 = Variant::factory()->create();
    $variant2->attributes()->attach($attribute, ['type' => 'text', 'value' => ['en' => 'blue']]);

    expect(Variant::whereAttributeIn('color', ['red'])->get())->toHaveCount(1);
    expect(Variant::whereAttributeIn('color', ['red'])->first())->toMatchArray(['id' => $variant->id]);
});
