<?php

use FirstpointCh\Shop\Models\Cart;
use FirstpointCh\Shop\Models\Customer;
use FirstpointCh\Shop\Models\Payment;
use FirstpointCh\Shop\Payment\Enums\PaymentStatus;

use function Pest\Laravel\actingAs;

/**
 * To display the success page, you must pass a valid reference as a query parameter.
 * The payment must belong to the current authenticated customer and the status must be "paid".
 */
test('it shows the success page', function () {
    $customer = Customer::factory()->create();
    $cart = Cart::factory()->create([
        'customer_id' => $customer->id,
        'is_active' => false,
    ]);
    $payment = Payment::factory()->create([
        'status' => 'paid',
        'customer_id' => $customer->id,
        'cart_id' => $cart->id,
        'reference' => 'testing123',
        'gateway' => 'test-gateway',
    ]);

    $this->get(route('shop::payment.success', ['gateway' => 'test-gateway', 'reference' => '123']))
        ->assertStatus(404); // The reference doesn't exist

    $this->get(route('shop::payment.success', ['gateway' => 'test-gateway', 'reference' => $payment->reference]))
        ->assertStatus(404); // Not authenticated

    $payment->update(['status' => PaymentStatus::Pending]);

    actingAs($customer, 'web');

    $this->get(route('shop::payment.success', ['gateway' => 'test-gateway', 'reference' => $payment->reference]))
        ->assertStatus(404); // The payment is not paid

    $payment->update(['status' => PaymentStatus::Paid]);

    $this->get(route('shop::payment.success', ['gateway' => 'test-gateway', 'reference' => $payment->reference]))
        ->assertStatus(200)
        ->assertSee('Commande confirmée');
});
