<?php

use FirstpointCh\Shop\Actions\GenerateInvoiceFromPayment;
use FirstpointCh\Shop\Models\Order;
use FirstpointCh\Shop\Models\OrderItem;
use FirstpointCh\Shop\Models\Payment;

it('generates an invoice', function () {
    $order = Order::factory()->create();
    $orderItem = OrderItem::factory()->create([
        'order_id' => $order->id,
    ]);
    $payment = Payment::factory()->create([
        'order_id' => $order->id,
    ]);

    $invoice = GenerateInvoiceFromPayment::run($payment);

    expect($invoice)->toBeInstanceOf(LaravelDaily\Invoices\Invoice::class);
});
