<?php

use FirstpointCh\Shop\Listeners\LogSentNotification;
use FirstpointCh\Shop\Models\Customer;
use Illuminate\Auth\Notifications\ResetPassword;
use Illuminate\Auth\Notifications\VerifyEmail;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Route;

it('dispatches an event when notifications are sent', function () {
    Event::fake();
    Route::get('/', fn () => 'ok')->name('verification.verify');
    Customer::factory()->create()->notify(new VerifyEmail());
    Event::assertDispatched('Illuminate\Notifications\Events\NotificationSent');
    Event::assertListening('Illuminate\Notifications\Events\NotificationSent', LogSentNotification::class);
});

// it('logs sent notifications', function () {
//     app()->setLocale('fr');

//     $token = 'token-1234';
//     $customer = Customer::factory()->create();
//     $customer->notify(new ResetPassword($token));

//     $this->assertDatabaseHas('notification_logs', [
//         'locale' => 'fr',
//         'type' => ResetPassword::class,
//         'data' => json_encode(['token' => 'token-1234']),
//         'via' => json_encode(['mail']),
//     ]);
// });
