<?php

namespace FirstpointCh\Shop\Traits;

use FirstpointCh\Shop\Models\CustomField;
use FirstpointCh\Shop\Models\CustomFieldModel;
use Illuminate\Database\Eloquent\Relations\MorphToMany;
use Illuminate\Support\Arr;

trait HasCustomFields
{
    public function customFields(): MorphToMany
    {
        return $this->morphToMany(CustomField::class, 'model', 'custom_field_model')
            ->whereJsonContains('enabled_models', static::class)
            ->withPivot('value')
            ->withTimestamps()
            ->using(CustomFieldModel::class);
    }

    /**
     * Takes an updated array of serialized custom fields and saves them to the model.
     */
    public function updateCustomFields(array $customFields, array $locales = [])
    {
        $customFields = collect($customFields)->mapWithKeys(fn ($customField) => [
            $customField['id'] => [
                'value' => ! empty($locales) && is_array($customField['pivot']['value']) ? Arr::only($customField['pivot']['value'], $locales) : $customField['pivot']['value'],
            ],
        ])->toArray();

        return $this->customFields()->sync($customFields);
    }

    public function getCustomField(string|array $key)
    {
        if (is_array($key)) {
            return $this->customFields->whereIn('key', $key)->map(fn ($item) => $item->pivot->value);
        }

        return $this->customFields->where('key', $key)->first()?->pivot->value;
    }
}
