<?php

namespace FirstpointCh\Shop\Payment;

use FirstpointCh\Shop\Cart\CartDriver;
use FirstpointCh\Shop\Models\Payment;
use FirstpointCh\Shop\Payment\Actions\CreatePaymentIntentAction;
use FirstpointCh\Shop\Payment\Enums\PaymentStatus;
use Illuminate\Http\Request;

class TestGateway implements PaymentGatewayInterface
{
    public string $name = 'Test gateway';

    public string $description = 'This is a test gateway';

    public string $handleMode = 'online';

    public ?Payment $payment = null;

    public function isEnabled(CartDriver $cart): bool
    {
        return app()->environment(['local', 'testing', 'test', 'dev']);
    }

    public function calculateFee(CartDriver $cart): float
    {
        return 0;
    }

    public function createPaymentIntent(CartDriver $cart): self
    {
        $this->payment = CreatePaymentIntentAction::run($cart, 'test-gateway');

        return $this;
    }

    public function redirect()
    {
        return redirect()
            ->route('shop::payment.handle', [
                'gateway' => 'test-gateway',
                'reference' => $this->payment->reference,
            ]);
    }

    public function handle(Request $request): Payment
    {
        $this->payment = Payment::where('reference', $request->reference)->first();

        if (empty($payment)) {
            $this->payment->update([
                'status' => PaymentStatus::Error,
                'status_message' => 'An error occured.',
            ]);
        }

        $this->payment->update([
            'status' => PaymentStatus::Paid,
            'status_message' => null,
        ]);

        return $this->payment;
    }
}
