<?php

namespace FirstpointCh\Shop\Payment;

use Illuminate\Support\Manager;

class PaymentGatewayManager extends Manager
{
    protected function createStripeCheckoutDriver()
    {
        return new StripeCheckoutGateway();
    }

    protected function createBankTransferDriver()
    {
        return new BankTransferGateway();
    }

    protected function createTestGatewayDriver()
    {
        return new TestGateway();
    }

    public function getDefaultDriver()
    {
        return 'stripe-checkout';
        // return $this->app['config']['services.payment_gateway.default'];
    }
}
