<?php

namespace FirstpointCh\Shop\Payment;

use FirstpointCh\Shop\Cart\CartDriver;
use FirstpointCh\Shop\Models\Payment;
use Illuminate\Http\Request;

interface PaymentGatewayInterface
{
    public function isEnabled(CartDriver $cart): bool;

    public function calculateFee(CartDriver $cart): float;

    public function createPaymentIntent(CartDriver $cart): self;

    public function redirect();

    public function handle(Request $request): Payment;
}
