<?php

namespace FirstpointCh\Shop\Payment\Enums;

enum PaymentStatus: string
{
    case Pending = 'pending';
    case Completed = 'completed';
    case Authorized = 'authorized';
    case Paid = 'paid';
    case Cancelled = 'cancelled';
    case Failed = 'failed';
    case Error = 'error';
    case Unknown = 'unknown';

    public function getLabel(): string
    {
        return match ($this) {
            self::Pending => 'En attente',
            self::Completed => 'Complété',
            self::Authorized => 'Autorisé',
            self::Paid => 'Payé',
            self::Cancelled => 'Annulé',
            self::Failed => 'Échoué',
            self::Error => 'Erreur',
            self::Unknown => 'Inconnu',
        };
    }
}
