<?php

namespace FirstpointCh\Shop\Payment;

use FirstpointCh\Shop\Cart\CartDriver;
use FirstpointCh\Shop\Models\Payment;
use FirstpointCh\Shop\Payment\Actions\CreatePaymentIntentAction;
use FirstpointCh\Shop\Payment\Enums\PaymentStatus;
use Illuminate\Http\Request;

class BankTransferGateway implements PaymentGatewayInterface
{
    public string $name = 'Virement bancaire';

    public string $description = 'Paiement par virement bancaire';

    public string $handleMode = 'online';

    public ?Payment $payment = null;

    public function isEnabled(CartDriver $cart): bool
    {
        return true;
    }

    public function calculateFee(CartDriver $cart): float
    {
        return 0;
    }

    public function createPaymentIntent(CartDriver $cart): self
    {
        $this->payment = CreatePaymentIntentAction::run($cart, 'bank-transfer');

        return $this;
    }

    public function redirect()
    {
        return redirect()
            ->route('shop::payment.handle', [
                'gateway' => 'bank-transfer',
                'reference' => $this->payment->reference,
            ]);
    }

    public function handle(Request $request): Payment
    {
        // Check that the payment belongs to the current user
        $this->payment = Payment::where('reference', $request->reference)->first();

        if (empty($payment)) {
            $this->payment->update([
                'status' => PaymentStatus::Error,
                'status_message' => 'An error occured.',
            ]);
        }

        $this->payment->update([
            'status' => PaymentStatus::Completed,
            'status_message' => null,
        ]);

        return $this->payment;
    }
}
