<?php

namespace FirstpointCh\Shop\Payment\Actions;

use FirstpointCh\Shop\Actions\Action;
use FirstpointCh\Shop\Cart\CartDriver;
use FirstpointCh\Shop\Models\Payment;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

/**
 * @method static Payment run(CartDriver $cart)
 */
class CreatePaymentIntentAction
{
    use Action;

    public function handle(CartDriver $cart, string $gateway): Payment
    {
        return DB::transaction(function () use ($cart, $gateway) {
            // Cancel previous payment
            Payment::where('cart_id', $cart->getCartIdentifier())->where('status', 'pending')->update([
                'status' => 'cancelled',
            ]);

            // Create new payment
            return Payment::create([
                'customer_id' => auth()->id(),
                'cart_id' => $cart->getCartIdentifier(),
                'reference' => Str::upper(Str::random(15)), // TODO: Generate unique reference
                'gateway' => $gateway,
                'amount' => $cart->getTotal(),
                'currency' => $cart->getRegion()->currency,
                'status' => 'pending',
            ]);
        });
    }
}
