<?php

namespace FirstpointCh\Shop\Models;

use Illuminate\Database\Eloquent\Relations\Pivot;

class ProductAssociation extends Pivot
{
    protected $table = 'product_associations';

    protected $guarded = [];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function associatedProduct()
    {
        return $this->belongsTo(Product::class, 'associated_product_id');
    }
}
