<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Payment\Enums\PaymentStatus;
use FirstpointCh\Shop\Traits\HasPackageFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property Cart $cart
 * @property ?Order $order
 */
class Payment extends Model
{
    use HasPackageFactory;

    protected $guarded = [];

    protected $casts = [
        'amount' => 'decimal:2',
        'status' => PaymentStatus::class,
    ];

    protected $appends = ['amount_formatted', 'status_label'];

    public function cart(): BelongsTo
    {
        return $this->belongsTo(Cart::class);
    }

    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }

    public function redirect()
    {
        return app('payment.'.$this->gateway)->redirect();
    }

    public function getStatusLabelAttribute()
    {
        return $this->status->getLabel();
    }

    public function getAmountFormattedAttribute()
    {
        return money()->format($this->amount);
    }
}
