<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Database\Factories\CustomerFactory;
use FirstpointCh\Shop\Traits\HasPackageFactory;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Customer extends Authenticatable implements MustVerifyEmail
{
    use HasPackageFactory, Notifiable;

    protected $guarded = [];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    protected static function newFactory() // TODO: Remove
    {
        return CustomerFactory::new();
    }

    public function cart()
    {
        return $this
            ->hasOne(Cart::class)
            ->where('is_active', true)
            ->where('region', shop()->getRegion()->slug)
            ->latestOfMany();
    }

    public function carts()
    {
        return $this->hasMany(Cart::class)->latest();
    }

    public function addresses()
    {
        return $this->hasMany(Address::class);
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function defaultAddress()
    {
        return $this->belongsTo(Address::class);
    }

    public function notificationLogs()
    {
        return $this->morphMany(NotificationLog::class, 'notifiable');
    }

    public function getFullNameAttribute()
    {
        return $this->first_name.' '.$this->last_name;
    }
}