<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\CustomField\AsCustomFieldValues;
use FirstpointCh\Shop\Traits\HasPackageFactory;
use FirstpointCh\Translatable\Traits\Translatable;
use Illuminate\Database\Eloquent\Relations\MorphPivot;

class CustomFieldModel extends MorphPivot
{
    use HasPackageFactory, Translatable;

    protected $guarded = [];

    protected $casts = [
        'value' => AsCustomFieldValues::class,
    ];

    public function model()
    {
        return $this->morphTo();
    }

    public function customField()
    {
        return $this->belongsTo(CustomField::class);
    }
}
