<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Traits\HasPackageFactory;
use FirstpointCh\Translatable\Casts\Localized;
use FirstpointCh\Translatable\Traits\Translatable;
use Illuminate\Database\Eloquent\Model;

class CustomField extends Model
{
    use HasPackageFactory, Translatable;

    protected $guarded = [];

    protected $casts = [
        'name' => Localized::class,
        'translatable' => 'boolean',
        'enabled_models' => 'array',
        'assigned_models' => 'array',
        'display_on_index' => 'boolean',
    ];

    protected $appends = [
        'field',
    ];

    public function getFieldAttribute()
    {
        return shop()->getFieldTypes()->filter(function ($field) {
            return $field['component'] === $this->type;
        })->first();
    }
}
