<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Coupon\Enums\CouponType;
use FirstpointCh\Shop\Traits\HasPackageFactory;
use FirstpointCh\Translatable\Casts\Localized;
use FirstpointCh\Translatable\Traits\Translatable;
use Illuminate\Database\Eloquent\Model;

class Coupon extends Model
{
    use HasPackageFactory, Translatable;

    protected $guarded = [];

    protected $casts = [
        'name' => Localized::class,
        'active_from' => 'datetime',
        'active_to' => 'datetime',
        'type' => CouponType::class,
    ];
}
