<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Traits\HasPackageFactory;
use FirstpointCh\Translatable\Casts\Localized;
use Illuminate\Database\Eloquent\Model;

class CatalogIndex extends Model
{
    use HasPackageFactory;

    protected $table = 'catalog_index';

    protected $guarded = [];

    protected $casts = [
        // 'product_name' => Localized::class,
        // 'variant_name' => Localized::class,
        'product_categories' => 'array',
        'product_attributes' => 'json',
        'variant_attributes' => 'json',
    ];

    protected $keyType = 'string';

    public $incrementing = false;

    protected static function booted()
    {
        static::addGlobalScope('region-aware', function ($builder) {
            $builder->when(shop()->isRegionAware(), function ($query) {
                $query->where('region', shop()->getRegion()->slug);
            });
        });
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function variant()
    {
        return $this->belongsTo(Variant::class);
    }

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function scopeOnRegion($query, $region)
    {
        $query->where('region', $region);
    }

    public function scopeActive($query)
    {
        $query->where('product_status', 'published')->where('variant_is_active', true);
    }

    public static function getAttributeValues($attribute)
    {
        return static::whereNotNull('product_attributes->'.$attribute)
            ->pluck('product_attributes')
            ->map(fn ($item) => $item[$attribute])
            ->merge(static::whereNotNull('variant_attributes->'.$attribute)
                ->pluck('variant_attributes')->map(fn ($item) => $item[$attribute]))
            ->unique()
            ->sort()
            ->values();
    }
}
