<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Traits\HasCustomFields;
use FirstpointCh\Shop\Traits\HasPackageFactory;
use FirstpointCh\Translatable\Casts\Localized;
use FirstpointCh\Translatable\Traits\Translatable;
use Illuminate\Database\Eloquent\Model;
use Staudenmeir\EloquentJsonRelations\HasJsonRelationships;

class Attribute extends Model
{
    use HasPackageFactory, Translatable, HasCustomFields, HasJsonRelationships;

    protected $guarded = [];

    protected $casts = [
        'name' => Localized::class,
        'translatable' => 'boolean',
        'filterable' => 'boolean',
        'option_value' => Localized::class,
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    public function productTypes()
    {
        return $this->belongsToMany(ProductType::class)
            ->withTimestamps();
    }

    public function options()
    {
        return $this->hasMany(AttributeOption::class);
    }

    public function scopeWithBaseTypes($query)
    {
        return $query->whereIn('type', [
            'text',
            'number',
            'options',
            'wysiwyg',
        ]);
    }

    public function getDefaultValue()
    {
        return null;
        // return $this->type === 'translated'
        //     ? [config('app.fallback_locale') => null]
        //     : null;
    }
}
