<?php

namespace FirstpointCh\Shop\Listeners;

use FirstpointCh\Shop\Models\Customer;
use Illuminate\Notifications\Events\NotificationSent;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Log;

class LogSentNotification
{
    /**
     * Handle the event.
     *
     * @return void
     */
    public function handle(NotificationSent $event)
    {
        if ($event->notifiable instanceof Customer) {
            try {
                $html = $event->notification->toMail($event->notifiable)->render()->toHtml();

                $event->notifiable->notificationLogs()->create([
                    'type' => get_class($event->notification),
                    'data' => $html,
                    'locale' => $event->notification->locale ?? app()->getLocale() ?? config('app.fallback_locale') ?? null,
                    'via' => $event->notification->via($event->notifiable),
                ]);
            } catch (\Exception $e) {
                // $event->notifiable->notificationLogs()->create([
                //     'type' => get_class($event->notification),
                //     'data' => '',
                //     'locale' => $event->notification->locale ?? app()->getLocale() ?? config('app.fallback_locale') ?? null,
                //     'via' => $event->notification->via($event->notifiable),
                // ]);

                Log::error($e->getMessage());
            }
        }
    }
}
