<?php

namespace FirstpointCh\Shop\Http\Middleware;

use Illuminate\Http\Request;
use Inertia\Middleware;

class HandleInertiaRequests extends Middleware
{
    /**
     * The root template that is loaded on the first page visit.
     *
     * @var string
     */
    protected $rootView = 'shop::cp';

    /**
     * Determine the current asset version.
     *
     * @return string|null
     */
    public function version(Request $request)
    {
        return parent::version($request);
    }

    /**
     * Define the props that are shared by default.
     *
     * @return array
     */
    public function share(Request $request)
    {
        return array_merge(parent::share($request), [
            'auth' => [
                'user' => $request->user('cp'),
            ],
            'app' => [
                'locales' => array_keys(config('shop.locales')),
            ],
            '_flash' => session()->only(session('_flash.old', [])),
            'locale' => app()->getLocale(),
            'fallbackLocale' => config('app.fallback_locale'),
            'customFieldTypes' => shop()->getFieldTypes(),
        ]);
    }
}
