<?php

namespace FirstpointCh\Shop\Http\Controllers;

use FirstpointCh\Shop\Cart\Cart;
use FirstpointCh\Shop\Models\Payment;
use FirstpointCh\Shop\Payment\Enums\PaymentStatus;
use FirstpointCh\Shop\Payment\PaymentGatewayManager;
use View;

class PaymentConfirmationController extends Controller
{
    public function __construct(
        public PaymentGatewayManager $gatewayManager
    ) {
    }

    public function __invoke(string $gateway)
    {
        if (empty(customer())) {
            abort(404);
        }

        $payment = Payment::where('reference', request()->reference)
            ->where('customer_id', customer()->id)
            ->firstOrFail();

        if (in_array($payment->status, [PaymentStatus::Paid, PaymentStatus::Authorized, PaymentStatus::Completed])) {
            Cart::destroy();

            return redirect()->route('shop::payment.success', [
                'gateway' => $gateway,
                'reference' => $payment->reference,
            ]);
        }

        if ($payment->status === PaymentStatus::Failed || $payment->status === PaymentStatus::Error) {
            return redirect()->route('shop::payment.error', [
                'gateway' => $gateway,
                'reference' => $payment->reference,
            ]);
        }

        return View::first(["shop::payment.{$gateway}.pending", 'shop::payment.default.pending'], [
            'gateway' => $this->gatewayManager->driver($gateway),
            'payment' => $payment,
        ]);
    }

    public function success(string $gateway)
    {
        if (empty(customer())) {
            abort(404);
        }

        $payment = Payment::where('reference', request()->reference)
            ->where('customer_id', customer()->id)
            ->whereIn('status', ['paid', 'authorized', 'completed'])
            ->firstOrFail();

        return View::first(["shop::payment.{$gateway}.success", 'shop::payment.default.success'], [
            'order' => $payment->order,
            'payment' => $payment,
        ]);
    }

    public function error(string $gateway)
    {
        return View::first(["shop::payment.{$gateway}.error", 'shop::payment.default.error'], [
            'message' => session('message', 'Une erreur s\'est produite.'),
        ]);
    }
}
