<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Models\Asset;
use Illuminate\Support\Facades\Storage;

// TODO: Move this to MediaLibraryController
class UploadController extends Controller
{
    public function store()
    {
        $data = request()->validate([
            'disk' => 'required|string',
            'path' => 'nullable|string',
            'files' => 'required|array',
            'files.*' => 'required|file',
        ]);

        $paths = [];

        foreach ($data['files'] as $file) {
            $extension = $file->getClientOriginalExtension();
            $filename = str($file->getClientOriginalName())
                ->replace('.'.$extension, '')
                ->slug();

            $counter = 0;
            while (Storage::disk($data['disk'])->exists($data['path'].'/'.$filename.($counter ? '-'.$counter : '').'.'.$extension)) {
                $counter++;
            }

            $path = $file->storeAs(
                $data['path'],
                $filename.($counter ? '-'.$counter : '').'.'.$extension,
                $data['disk'],
            );

            $asset = Asset::create([
                'disk' => $data['disk'],
                'path' => $path,
                'display_name' => [config('app.locale') => null],
                'alt_text' => [config('app.locale') => null],
                'mime_type' => $file->getMimeType(),
                'size' => $file->getSize(),
            ]);

            if ($asset->mime_type && str_starts_with($asset->mime_type, 'image/')) {
                $asset->regenerateConversions(null, true);
            }

            $paths[] = [
                'path' => $path,
                'asset_id' => $asset->id,
            ];
        }

        return $paths;
    }

    public function renameFile()
    {
        $data = request()->validate([
            'disk' => 'required|string|in:'.implode(',', array_keys(config('shop.media'))),
            'oldName' => 'required|string',
            'newName' => 'required|string',
        ]);

        $basePath = config('filesystem.'.$data['disk'].'.root');

        $oldPath = $basePath.'/'.$data['oldName'];
        $newPath = $basePath.'/'.$data['newName'];

        Storage::disk($data['disk'])->move($oldPath, $newPath);

        return $data['newName'];
    }
}
