<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Http\Requests\DatatableRequest;
use FirstpointCh\Shop\Models\Address;
use FirstpointCh\Shop\Models\Customer;
use FirstpointCh\Shop\Region;
use Inertia\Inertia;

class CustomerAddressController extends Controller
{
	public function store(Customer $customer)
	{
		$data = request()->validate([
			'first_name' => 'required',
			'last_name' => 'required',
			'company' => 'nullable',
			'street' => 'required',
			'street_number' => 'required',
			'zip' => 'required',
			'city' => 'required',
			'country' => 'required|size:2',
			'vat_number' => 'nullable',
			'registration_number' => 'nullable'
		]);

		$customer->addresses()->create($data);

		return redirect()->back()->with('toast', [
			'title' => 'Adresse ajoutée',
			'message' => 'L\'adresse a bien été ajoutée',
			'type' => 'success',
		]);
	}

    public function update(Customer $customer, Address $address)
    {
        $data = request()->validate([
			'first_name' => 'required',
			'last_name' => 'required',
            'company' => 'nullable',
            'street' => 'required',
            'street_number' => 'required',
            'zip' => 'required',
            'city' => 'required',
            'country' => 'required|size:2',
            'vat_number' => 'nullable',
            'registration_number' => 'nullable'
        ]);

        $address->update($data);

        return redirect()->back()->with('toast', [
            'title' => 'Adresse mise à jour',
            'message' => 'L\'adresse a bien été mise à jour',
            'type' => 'success',
        ]);
    }
}
