<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Http\Requests\DatatableRequest;
use FirstpointCh\Shop\Models\CustomField;
use Inertia\Inertia;

class CustomFieldController extends Controller
{
    public function index(DatatableRequest $datatable)
    {
        return Inertia::render('CustomField/Index', [
            'datatableState' => $datatable
                ->searchable(['name'])
                ->query(CustomField::query())
                ->getState(),
        ]);
    }

    public function create()
    {
        return Inertia::render('CustomField/Form');
    }

    public function store()
    {
        CustomField::create(request()->validate([
            'name' => 'required',
            'key' => 'required',
            'type' => 'required',
            'description' => 'nullable',
            'translatable' => 'required|boolean',
            'enabled_models' => 'nullable|array',
            'assigned_models' => 'nullable|array',
            'display_on_index' => 'required|boolean',
        ]));

        return redirect('/cp/custom-fields');
    }

    public function edit(CustomField $customField)
    {
        return Inertia::render('CustomField/Form', [
            'customField' => $customField->in('*'),
        ]);
    }

    public function update(CustomField $customField)
    {
        $customField->update(request()->validate([
            'name' => 'required',
            'key' => 'required',
            'type' => 'required',
            'description' => 'nullable',
            'translatable' => 'required|boolean',
            'enabled_models' => 'nullable|array',
            'assigned_models' => 'nullable|array',
            'display_on_index' => 'required|boolean',
        ]));

        return redirect('/cp/custom-fields');
    }

    public function delete(CustomField $customField)
    {
        $customField->delete();

        return redirect('/cp/custom-fields');
    }
}
