<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Http\Requests\DatatableRequest;
use FirstpointCh\Shop\Models\Coupon;
use Inertia\Inertia;

class CouponController extends Controller
{
    public function index(DatatableRequest $datatable)
    {
        return Inertia::render('Coupon/Index', [
            'datatableState' => $datatable
                ->searchable(['name'])
                ->query(Coupon::query())
                ->getState(),
        ]);
    }

    public function create()
    {
        return Inertia::render('Coupon/Form');
    }

    public function store()
    {
        Coupon::create(request()->validate([
            'name' => 'required',
            'code' => 'required',
            'type' => 'required|in:fixed_amount,percentage',
            'value' => 'required',
            'active_from' => 'nullable|date',
            'active_to' => 'nullable|date',
        ]));

        return redirect('/cp/coupons');
    }

    public function edit(Coupon $coupon)
    {
        return Inertia::render('Coupon/Form', [
            'coupon' => $coupon->in('*'),
        ]);
    }

    public function update(Coupon $coupon)
    {
        $coupon->update(request()->validate([
            'name' => 'required',
            'code' => 'required',
            'type' => 'required|in:fixed_amount,percentage',
            'value' => 'required',
            'active_from' => 'nullable|date',
            'active_to' => 'nullable|date',
        ]));

        return redirect('/cp/coupons');
    }
}
