<?php

namespace FirstpointCh\Shop\Data\Cp;

use Illuminate\Validation\Rule;
use Spatie\LaravelData\Data;

class ProductFormData extends Data
{
    public function __construct(
        public array $name,
        public array $slug,
        public ?int $product_type_id = null,
        public ?string $status = 'draft',
        public ?array $short_description = null,
        public ?array $description = null,
        public ?array $attribute_data = [],
        public ?array $categories = [],
        public ?int $brand_id = null,
        public ?array $custom_fields = [],
        public ?array $meta_title = [],
        public ?array $meta_description = [],
    ) {
    }

    public static function rules(): array
    {
        $fallbackLocale = config('app.fallback_locale');

        return [
            'status' => 'nullable',
            'name.'.$fallbackLocale => 'required',
            'slug.'.$fallbackLocale => [
                'required',
                Rule::unique('products', 'slug->'.$fallbackLocale)->ignore(request()->route('product')?->id),
            ],
            'short_description' => 'nullable',
            'description' => 'nullable',
            'product_type_id' => 'nullable|exists:product_types,id',
            'brand_id' => 'nullable|exists:brands,id',
            'attribute_data' => 'nullable|array',
            // 'attribute_data.*.id' => 'required|exists:attributes,id',
            // 'attribute_data.*.value' => 'nullable',
            'custom_fields' => 'nullable|array',
            'meta_title' => 'nullable|array',
            'meta_description' => 'nullable|array',
        ];
    }

    public function getProductData(): array
    {
        return [
            'status' => $this->status,
            'name' => array_filter($this->name, fn ($value) => ! empty($value)),
            'slug' => array_filter($this->slug, fn ($value) => ! empty($value)),
            'short_description' => array_filter($this->short_description, fn ($value) => ! empty($value)),
            'description' => array_filter($this->description, fn ($value) => ! empty($value) && $value !== '<p></p>'),
            'product_type_id' => $this->product_type_id,
            'brand_id' => $this->brand_id,
            'meta_title' => array_filter($this->meta_title, fn ($value) => ! empty($value)),
            'meta_description' => array_filter($this->meta_description, fn ($value) => ! empty($value)),
            'attribute_data' => $this->attribute_data,
        ];
    }

    public function getCategoryData(): array
    {
        return array_filter($this->categories, fn ($value) => ! empty($value));
    }

    // public function getAttributes(): array
    // {
    //     return collect($this->attribute_data)
    //         ->mapWithKeys(fn ($attr) => [$attr['key'] => $attr['value']])
    //         ->toArray();
    // }
}
