<?php

namespace FirstpointCh\Shop\CustomField;

use Illuminate\Contracts\Support\Arrayable;

class CustomFieldValue implements Arrayable
{
    public $rawValue;

    public $translatable;

    public function __construct($value)
    {
        $this->rawValue = $value;

        $this->translatable = is_array($value) && array_key_exists(config('app.fallback_locale'), $value);
    }

    public function __get($name)
    {
        if ($name === 'value') {
            if ($this->translatable) {
                return $this->rawValue[app()->getLocale()]
                    ?? $this->rawValue[config('app.fallback_locale')]
                    ?? '';
            } else {
                return $this->rawValue;
            }
        }

        if ($this->translatable) {
            return $this->rawValue[app()->getLocale()][$name]
                ?? $this->rawValue[config('app.fallback_locale')][$name]
                ?? null;
        }

        return $this->rawValue[$name] ?? null;
    }

    public function __toString()
    {
        if (is_string($this->rawValue) || is_numeric($this->rawValue)) {
            return $this->rawValue;
        }

        if ($this->translatable) {
            return $this->rawValue[app()->getLocale()]
                ?? $this->rawValue[config('app.fallback_locale')]
                ?? '';
        }

        return json_encode($this->rawValue);
    }

    public function toArray()
    {
        return $this->rawValue;
    }
}
