<?php

namespace FirstpointCh\Shop\Commands;

use FirstpointCh\Shop\Models\Asset;
use Illuminate\Console\Command;

class GenerateSingleAssetConversions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'assets:generate-single {asset}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $asset = Asset::query()
            ->where('mime_type', 'like', 'image/%')
            ->findOrFail($this->argument('asset'));

        $config = config('shop.media.'.$asset->disk.'.conversions');

        $asset->regenerateConversions($config, true);

        return 0;
    }
}
