<?php

namespace FirstpointCh\Shop\Commands;

use FirstpointCh\Shop\Actions\Asset\RefreshFromDisk;
use FirstpointCh\Shop\Models\Asset;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Storage;

class GenerateAssetConversions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'assets:regenerate {--overwrite}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '';

    protected $refreshAssetsAction;

    public function __construct(RefreshFromDisk $refreshAssetsAction)
    {
        parent::__construct();

        $this->refreshAssetsAction = $refreshAssetsAction;
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // if ($this->option('overwrite')) {
        //     Storage::disk(config('shop.media_conversion_disk'))->deleteDirectory('');
        // }

        foreach (config('shop.media') as $disk => $config) {
            if (empty($config['conversions'])) {
                continue;
            }

            $this->line('Refreshing assets for disk: '.$disk);

            $this->refreshAssetsAction->run($disk);

            $bar = $this->output->createProgressBar(
                Asset::query()->where('disk', $disk)->where('mime_type', 'like', 'image/%')->count()
            );

            Asset::query()
                ->where('disk', $disk)
                ->where('mime_type', 'like', 'image/%')
                ->chunk(100, function ($assets) use ($config, $bar) {
                    $assets->each->regenerateConversions($config['conversions'], $this->option('overwrite'));

                    $bar->advance(100);
                });

            $bar->finish();
        }

        return Command::SUCCESS;
    }
}
