<?php

namespace FirstpointCh\Shop\Commands;

use FirstpointCh\Shop\Models\Attribute;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Cache;

class CacheAttributes extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'shop:cache-attributes';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clear attribute cache and rebuild it';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        Cache::forget('attributes');

        Cache::rememberForever('attributes', function () {
            return Attribute::all()->keyBy('key');
        });

        return Command::SUCCESS;
    }
}
