<?php

namespace FirstpointCh\Shop\Cart;

use FirstpointCh\Shop\Models\TaxRule;
use FirstpointCh\Shop\Models\Variant;
use Illuminate\Support\Collection;

// TODO: Make this class readonly
class SessionCartItem
{
    private $memoizedVariant;

    public function __construct(
        public string $id,
        public string $reference,
        public string $name,
        public float $unit_price,
        public int $quantity,
        public array $meta = [],
        public ?Collection $taxes = null,
    ) {
        //
    }

    public function __get($key)
    {
        if ($key === 'variant') {
            if ($this->memoizedVariant) {
                return $this->memoizedVariant;
            }

            return $this->variant();
        } elseif ($key === 'price') {
            return $this->unit_price * $this->quantity;
        }

        return $this->{$key};
    }

    public function variant()
    {
        $variant = Variant::where('reference', $this->reference)->withPrice()->first();

        $this->memoizedVariant = $variant;

        return $variant;
    }

    public function recalculateTaxes(): self
    {
        $this->taxes = TaxRule::query()
            ->forProduct($this->variant()->product)
            ->get()
            ->map(fn (TaxRule $taxRule) => [
                'tax_rule_id' => $taxRule->id,
                'name' => $taxRule->name,
                'tax_included' => $taxRule->tax_included,
                'taxable_amount' => $this->unit_price * $this->quantity,
                'rate' => $taxRule->rate,
                'amount' => $taxRule->tax_included
                    ? $this->unit_price * $this->quantity * $taxRule->rate / (100 + $taxRule->rate)
                    : $this->unit_price * $this->quantity * $taxRule->rate / 100,
            ])
            ->values();

        return $this;
    }
}
