<?php

namespace FirstpointCh\Shop\Cart;

use FirstpointCh\Shop\Cart\Drivers\DatabaseCart;
use FirstpointCh\Shop\Cart\Drivers\SessionCart;
use Illuminate\Support\Manager;
use InvalidArgumentException;

class CartManager extends Manager
{
    public function getDefaultDriver()
    {
        return auth()->check() ? 'database' : 'session';
    }

    public function createSessionDriver()
    {
        return tap($this->container->make(SessionCart::class), function ($driver) {
            $driver->init(shop()->getRegion()->slug);
        });
    }

    public function createDatabaseDriver()
    {
        return tap($this->container->make(DatabaseCart::class), function ($driver) {
            $driver->init(shop()->getRegion()->slug, auth()->user());
        });
    }

    public function driver($driver = null)
    {
        return $this->createDriver(
            $driver ?: $this->getDefaultDriver()
        ) ?? throw new InvalidArgumentException(
            sprintf('Unable to resolve NULL driver for [%s].', static::class)
        );
    }
}
